/*
 * Decompiled with CFR 0.152.
 */
package com.anjlab.android.iab.v3;

import android.content.Context;
import android.text.TextUtils;
import com.anjlab.android.iab.v3.BillingBase;
import com.anjlab.android.iab.v3.PurchaseInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;

class BillingCache
extends BillingBase {
    private static final String ENTRY_DELIMITER = "#####";
    private static final String LINE_DELIMITER = ">>>>>";
    private static final String VERSION_KEY = ".version";
    private HashMap<String, PurchaseInfo> data = new HashMap();
    private String cacheKey;
    private String version;

    BillingCache(Context context, String key) {
        super(context);
        this.cacheKey = key;
        this.load();
    }

    private String getPreferencesCacheKey() {
        return this.getPreferencesBaseKey() + this.cacheKey;
    }

    private String getPreferencesVersionKey() {
        return this.getPreferencesCacheKey() + VERSION_KEY;
    }

    private void load() {
        String[] entries;
        for (String entry : entries = this.loadString(this.getPreferencesCacheKey(), "").split(Pattern.quote(ENTRY_DELIMITER))) {
            if (TextUtils.isEmpty((CharSequence)entry)) continue;
            String[] parts = entry.split(Pattern.quote(LINE_DELIMITER));
            if (parts.length > 2) {
                this.data.put(parts[0], new PurchaseInfo(parts[1], parts[2]));
                continue;
            }
            if (parts.length <= 1) continue;
            this.data.put(parts[0], new PurchaseInfo(parts[1], null));
        }
        this.version = this.getCurrentVersion();
    }

    private void flush() {
        ArrayList<String> output = new ArrayList<String>();
        for (String productId : this.data.keySet()) {
            PurchaseInfo info = this.data.get(productId);
            output.add(productId + LINE_DELIMITER + info.responseData + LINE_DELIMITER + info.signature);
        }
        this.saveString(this.getPreferencesCacheKey(), TextUtils.join((CharSequence)ENTRY_DELIMITER, output));
        this.version = Long.toString(new Date().getTime());
        this.saveString(this.getPreferencesVersionKey(), this.version);
    }

    boolean includesProduct(String productId) {
        this.reloadDataIfNeeded();
        return this.data.containsKey(productId);
    }

    PurchaseInfo getDetails(String productId) {
        this.reloadDataIfNeeded();
        return this.data.containsKey(productId) ? this.data.get(productId) : null;
    }

    void put(String productId, String details, String signature) {
        this.reloadDataIfNeeded();
        if (!this.data.containsKey(productId)) {
            this.data.put(productId, new PurchaseInfo(details, signature));
            this.flush();
        }
    }

    void remove(String productId) {
        this.reloadDataIfNeeded();
        if (this.data.containsKey(productId)) {
            this.data.remove(productId);
            this.flush();
        }
    }

    void clear() {
        this.reloadDataIfNeeded();
        this.data.clear();
        this.flush();
    }

    private String getCurrentVersion() {
        return this.loadString(this.getPreferencesVersionKey(), "0");
    }

    private void reloadDataIfNeeded() {
        if (!this.version.equalsIgnoreCase(this.getCurrentVersion())) {
            this.data.clear();
            this.load();
        }
    }

    List<String> getContents() {
        return new ArrayList<String>(this.data.keySet());
    }

    public String toString() {
        return TextUtils.join((CharSequence)", ", this.data.keySet());
    }
}

