package com.app.radiofrankfurt.service;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Intent;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import android.support.v4.media.session.MediaSessionCompat;
import android.util.Log;

import androidx.annotation.RequiresApi;

import com.app.radiofrankfurt.MainActivity;
import com.app.radiofrankfurt.R;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.ext.mediasession.MediaSessionConnector;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class MusicService extends Service {
    private static final String TAG = "BackgroundSoundService";
    MediaPlayer player;
    private int _playbackState = -1;
    ExoPlayer exoPlayer;

    public MusicService() {
    }

    @Override
    public IBinder onBind(Intent intent) {
        Log.d(TAG, "onBind: " + intent.getStringExtra("stream_url"));
        return new Binder();
    }

    @RequiresApi(api = Build.VERSION_CODES.S)
    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d(TAG, "onStartCommand: " + intent.getStringExtra("stream_url"));

        String url = intent.getStringExtra("stream_url");

        exoPlayer = new ExoPlayer.Builder(getApplicationContext()).build();
        exoPlayer.addListener(new Player.Listener() {
            @Override
            public void onPlaybackStateChanged(int playbackState) {
                Log.d(TAG, "onPlaybackStateChanged: " + playbackState);
                _playbackState = playbackState;
                switch (playbackState) {
                    case Player.STATE_READY:
                        exoPlayer.setPlayWhenReady(true);
                        break;
                    case Player.STATE_ENDED:
                    case Player.STATE_BUFFERING:
                        Log.d(TAG, "onPlaybackStateChanged: " + "Buffering");
                        exoPlayer.setPlayWhenReady(true);
                        exoPlayer.seekTo(0);
                        break;
                    case Player.STATE_IDLE:
                        exoPlayer.prepare();
                        exoPlayer.setPlayWhenReady(true);
                        break;
                }
            }
        });

        MediaItem mediaItem = MediaItem.fromUri(url);
        exoPlayer.addMediaItem(mediaItem);
        exoPlayer.prepare();
        exoPlayer.setPlayWhenReady(true);

        Map<String, String> headers = new HashMap<>();
        headers.put("Content-Type", "audio/mp3"); // change content type if necessary
        headers.put("Accept-Ranges", "bytes");
        headers.put("Status", "206");
        headers.put("Cache-control", "no-cache");
        notification();

        // Do this every 5 minutes
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask() {
            @Override
            public void run() {
                Log.d(TAG, "run: " + "Timer");
                if(exoPlayer != null) {
                    Log.d(TAG, "run: " + _playbackState);
                }
                notification();
            }
        }, 5000, 60000); // 60000 milliseconds = 1 minute
//        // buffer...
//        try {
//            player.prepare();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        player.start();

        return START_STICKY;
    }

    @Override
    public void onDestroy() {
        if (exoPlayer != null) {
            exoPlayer.stop();
            exoPlayer.release();
        } // if end

        // Remove notification
        stopForeground(true);
    }

    private void notification() {
        final String CHANNELID = "Foreground Service ID";
        Log.d(TAG, "notification: " + CHANNELID);
        NotificationChannel channel = null;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.O) {
            channel = new NotificationChannel(
                    CHANNELID,
                    CHANNELID,
                    NotificationManager.IMPORTANCE_LOW
            );
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                getSystemService(NotificationManager.class).createNotificationChannel(channel);
            }
        }

        Notification.Builder notification = null;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            // Stop action
            notification = new Notification.Builder(this, CHANNELID)
                    .setContentText(getString(R.string.app_name))
                    .setContentTitle("Klicken, um die App zu öffnen")
                    .setAutoCancel(false)
                    .setOngoing(true)
                    .setSmallIcon(R.drawable.play_circle);

            // start app on click
            Intent notificationIntent = new Intent(this, MainActivity.class);
            notificationIntent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP | Intent.FLAG_ACTIVITY_SINGLE_TOP);
            PendingIntent pendingIntent = PendingIntent.getActivity(this, 0, notificationIntent, PendingIntent.FLAG_MUTABLE);
            notification.setContentIntent(pendingIntent);

            startForeground(1001, notification.build());
        }
    }
}