package com.app.radiofrankfurt.javascript;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import android.webkit.JavascriptInterface;

import com.app.radiofrankfurt.service.MusicService;

public class JavaScriptRadioInterface {
    private static String TAG = "JavaScriptRadioInterface";

    Context mContext;

    /** Instantiate the interface and set the context */
    public JavaScriptRadioInterface(Context c) {
        mContext = c;
    }

    private boolean isMyServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager) mContext.getSystemService(Context.ACTIVITY_SERVICE);
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (serviceClass.getName().equals(service.service.getClassName())) {
                return true;
            } // if end
        } // for end

        return false;
    }

    @JavascriptInterface
    public void play(String url) {
        if(isMyServiceRunning(MusicService.class)) {
            return;
        } // if end

        Log.d(TAG, "play: " + url);
        Intent service = new Intent(mContext, MusicService.class);
        service.putExtra("stream_url", url);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            mContext.startForegroundService(service);
        }
        else {
            mContext.startService(service);
        }
    }

    @JavascriptInterface
    public void stop() {
        Log.d(TAG, "stop");
        Intent service = new Intent(mContext, MusicService.class);
        mContext.stopService(service);
    }
}
