/*
 * Decompiled with CFR 0.152.
 */
package com.anjlab.android.iab.v3;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

class BillingBase {
    private Context context;

    BillingBase(Context context) {
        this.context = context;
    }

    Context getContext() {
        return this.context;
    }

    String getPreferencesBaseKey() {
        return this.getContext().getPackageName() + "_preferences";
    }

    private SharedPreferences getPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)this.getContext());
    }

    boolean saveString(String key, String value) {
        SharedPreferences sp = this.getPreferences();
        if (sp != null) {
            SharedPreferences.Editor spe = sp.edit();
            spe.putString(key, value);
            spe.commit();
            return true;
        }
        return false;
    }

    String loadString(String key, String defValue) {
        SharedPreferences sp = this.getPreferences();
        if (sp != null) {
            return sp.getString(key, defValue);
        }
        return defValue;
    }

    boolean saveBoolean(String key, Boolean value) {
        SharedPreferences sp = this.getPreferences();
        if (sp != null) {
            SharedPreferences.Editor spe = sp.edit();
            spe.putBoolean(key, value.booleanValue());
            spe.commit();
            return true;
        }
        return false;
    }

    boolean loadBoolean(String key, boolean defValue) {
        SharedPreferences sp = this.getPreferences();
        if (sp != null) {
            return sp.getBoolean(key, defValue);
        }
        return defValue;
    }
}

